#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.transformation import Transformation

class ImageAugmentationListPatchParam(APIObject):
    """
    Attributes
    ----------
    feature_name:str [optional]
         The name of the image feature containing the data to be augmented. 
    in_use:bool [optional]
         This is set to true when the Augmentation List has been used to train a model. 
    initial_list:bool [optional]
         Whether this list will be used during autopilot to perform image augmentation. 
    name:str [optional]
         The name of the image augmentation list. 
    number_of_new_images:int [optional]
         Number of new rows to add for each existing row. 
    project_id:str [optional]
         The project containing the image data to be augmented. 
    transformation_probability:float [optional]
         Probability that each enabled transformation will be applied to an image. This does not apply to Horizontal or Vertical Flip, which are set to 50% always.. 
    transformations:[Transformation] [optional]
         List of Transformations to possibly apply to each image. 
    """
    _converter = t.Dict(
        {
            t.Key("feature_name", optional=True):  t.String(),
            t.Key("in_use", optional=True):  t.Bool(),
            t.Key("initial_list", optional=True):  t.Bool(),
            t.Key("name", optional=True):  t.String(),
            t.Key("number_of_new_images", optional=True):  t.Int(),
            t.Key("project_id", optional=True):  t.String(),
            t.Key("transformation_probability", optional=True):  t.Float(),
            t.Key("transformations", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature_name=None,
        in_use=None,
        initial_list=None,
        name=None,
        number_of_new_images=None,
        project_id=None,
        transformation_probability=None,
        transformations=None,
    ):
        self.feature_name = feature_name
        self.in_use = in_use
        self.initial_list = initial_list
        self.name = name
        self.number_of_new_images = number_of_new_images
        self.project_id = project_id
        self.transformation_probability = transformation_probability
        self.transformations = transformations

    def __repr__(self):
        return (
            "ImageAugmentationListPatchParam("
            "feature_name={0.feature_name}, "
            "in_use={0.in_use}, "
            "initial_list={0.initial_list}, "
            "name={0.name}, "
            "number_of_new_images={0.number_of_new_images}, "
            "project_id={0.project_id}, "
            "transformation_probability={0.transformation_probability}, "
            "transformations={0.transformations}, "
        ).format(self)
