#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.image_augmentation_options_transformation import ImageAugmentationOptionsTransformation

class ImageAugmentationOptionsResponse(APIObject):
    """
    Attributes
    ----------
    current_number_of_new_images:int
         Number of new images to be created for each original image during training
    current_transformation_probability:float
         Probability that each transformation included in an augmentation list will be applied to an image, if `affectedByTransformationProbability` for that transformation is True
    id:str
         Augmentation list id
    max_number_of_new_images:int
         Maximum number of new images per original image to be generated during training
    max_transformation_probability:float
         Maximum probability that each enabled augmentation will be applied to an image
    min_number_of_new_images:int
         Minimum number of new images per original image to be generated during training
    min_transformation_probability:float
         Minimum probability that each enabled augmentation will be applied to an image
    name:str
         The name of the augmentation list
    project_id:str
         The id of the project containing the image data to be augmented
    transformations:[ImageAugmentationOptionsTransformation]
         List of Transformations to possibly apply to each image
    feature_name:str [optional]
         Name of the image feature that the augmentation list is associated with. 
    """
    _converter = t.Dict(
        {
            t.Key("current_number_of_new_images"):  t.Int(),
            t.Key("current_transformation_probability"):  t.Float(),
            t.Key("id"):  t.String(),
            t.Key("max_number_of_new_images"):  t.Int(),
            t.Key("max_transformation_probability"):  t.Float(),
            t.Key("min_number_of_new_images"):  t.Int(),
            t.Key("min_transformation_probability"):  t.Float(),
            t.Key("name"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("transformations"):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        current_number_of_new_images,
        current_transformation_probability,
        id,
        max_number_of_new_images,
        max_transformation_probability,
        min_number_of_new_images,
        min_transformation_probability,
        name,
        project_id,
        transformations,
        feature_name=None,
    ):
        self.current_number_of_new_images = current_number_of_new_images
        self.current_transformation_probability = current_transformation_probability
        self.id = id
        self.max_number_of_new_images = max_number_of_new_images
        self.max_transformation_probability = max_transformation_probability
        self.min_number_of_new_images = min_number_of_new_images
        self.min_transformation_probability = min_transformation_probability
        self.name = name
        self.project_id = project_id
        self.transformations = transformations
        self.feature_name = feature_name

    def __repr__(self):
        return (
            "ImageAugmentationOptionsResponse("
            "current_number_of_new_images={0.current_number_of_new_images}, "
            "current_transformation_probability={0.current_transformation_probability}, "
            "id={0.id}, "
            "max_number_of_new_images={0.max_number_of_new_images}, "
            "max_transformation_probability={0.max_transformation_probability}, "
            "min_number_of_new_images={0.min_number_of_new_images}, "
            "min_transformation_probability={0.min_transformation_probability}, "
            "name={0.name}, "
            "project_id={0.project_id}, "
            "transformations={0.transformations}, "
            "feature_name={0.feature_name}, "
        ).format(self)
