#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.image_augmentation_options_transformation_param import ImageAugmentationOptionsTransformationParam

class ImageAugmentationOptionsTransformation(APIObject):
    """
    Attributes
    ----------
    affected_by_transformation_probability:bool
         If true, whenever this transformation is included in an augmentation list, this transformation will be applied to each image with probability set by the Transformation Probability. If false, whenever this transformation is included in an augmentation list, this transformation will be applied to each image with probability described in the Platform Documentation here: https://app.datarobot.com/docs/modeling/special-workflows/visual-ai/tti-augment/ttia-lists.html#transformations
    enabled_by_default:bool
         Determines if the parameter should be default selected in the UI
    name:str
         The name of the transformation
    params:[ImageAugmentationOptionsTransformationParam]
         The list of parameters that control the transformation
    translated_name:str
         Translated name of the transformation
    """
    _converter = t.Dict(
        {
            t.Key("affected_by_transformation_probability"):  t.Bool(),
            t.Key("enabled_by_default"):  t.Bool(),
            t.Key("name"):  t.String(),
            t.Key("params"):  t.List(t.Dict().allow_extra("*")),
            t.Key("translated_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        affected_by_transformation_probability,
        enabled_by_default,
        name,
        params,
        translated_name,
    ):
        self.affected_by_transformation_probability = affected_by_transformation_probability
        self.enabled_by_default = enabled_by_default
        self.name = name
        self.params = params
        self.translated_name = translated_name

    def __repr__(self):
        return (
            "ImageAugmentationOptionsTransformation("
            "affected_by_transformation_probability={0.affected_by_transformation_probability}, "
            "enabled_by_default={0.enabled_by_default}, "
            "name={0.name}, "
            "params={0.params}, "
            "translated_name={0.translated_name}, "
        ).format(self)
