#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ImageAugmentationOptionsTransformationParam(APIObject):
    """
    Attributes
    ----------
    name:str
         Transformation param name
    translated_name:str
         Translated name of the parameter
    type:str
         The type of the parameter (int, float, etc...)
    current_value:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Current transformation value. 
    max_value:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Max transformation value. 
    min_value:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Min transformation value. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("translated_name"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("current_value", optional=True):  t.Any(),
            t.Key("max_value", optional=True):  t.Any(),
            t.Key("min_value", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        translated_name,
        type,
        current_value=None,
        max_value=None,
        min_value=None,
    ):
        self.name = name
        self.translated_name = translated_name
        self.type = type
        self.current_value = current_value
        self.max_value = max_value
        self.min_value = min_value

    def __repr__(self):
        return (
            "ImageAugmentationOptionsTransformationParam("
            "name={0.name}, "
            "translated_name={0.translated_name}, "
            "type={0.type}, "
            "current_value={0.current_value}, "
            "max_value={0.max_value}, "
            "min_value={0.min_value}, "
        ).format(self)
