#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ImageAugmentationRetrieveSamplesItem(APIObject):
    """
    Attributes
    ----------
    height:int
         Height of the image in pixels
    image_id:str
         Id of the image. The augmented image file can be retrieved with :http:get:`/api/v2/projects/(projectId)/images/(imageId)/file/`
    original_image_id:str, none_type
         Id of the original image that was transformed to produce the augmented image. If this is an original image (from the original training dataset) this value will be null. The id can be used to retrieve the original image file with: :http:get:`/api/v2/projects/(projectId)/images/(imageId)/file/`
    width:int
         Width of the image in pixels
    """
    _converter = t.Dict(
        {
            t.Key("height"):  t.Int(),
            t.Key("image_id"):  t.String(),
            t.Key("original_image_id"):  t.String(),
            t.Key("width"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        height,
        image_id,
        original_image_id,
        width,
    ):
        self.height = height
        self.image_id = image_id
        self.original_image_id = original_image_id
        self.width = width

    def __repr__(self):
        return (
            "ImageAugmentationRetrieveSamplesItem("
            "height={0.height}, "
            "image_id={0.image_id}, "
            "original_image_id={0.original_image_id}, "
            "width={0.width}, "
        ).format(self)
