#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.image_embedding_prediction import ImageEmbeddingPrediction

class ImageEmbedding(APIObject):
    """
    Attributes
    ----------
    actual_target_value:bool, date, datetime, dict, float, int, list, str, none_type
         Actual target value of the dataset row.
    image_id:str
         Id of the image. The actual image file can be retrieved with :http:get:`/api/v2/projects/(projectId)/images/(imageId)/file/`.
    position_x:float
         x coordinate of the image in the embedding space.
    position_y:float
         y coordinate of the image in the embedding space.
    prediction:ImageEmbeddingPrediction
        
    """
    _converter = t.Dict(
        {
            t.Key("actual_target_value"):  t.Any(),
            t.Key("image_id"):  t.String(),
            t.Key("position_x"):  t.Float(),
            t.Key("position_y"):  t.Float(),
            t.Key("prediction"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual_target_value,
        image_id,
        position_x,
        position_y,
        prediction,
    ):
        self.actual_target_value = actual_target_value
        self.image_id = image_id
        self.position_x = position_x
        self.position_y = position_y
        self.prediction = prediction

    def __repr__(self):
        return (
            "ImageEmbedding("
            "actual_target_value={0.actual_target_value}, "
            "image_id={0.image_id}, "
            "position_x={0.position_x}, "
            "position_y={0.position_y}, "
            "prediction={0.prediction}, "
        ).format(self)
