#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ImageMetadataResponse(APIObject):
    """
    Attributes
    ----------
    height:int
         Height of the image in pixels
    image_id:str
         Id of the image. The actual image file can be retrieved with :http:get:`/api/v2/projects/(projectId)/images/(imageId)/file/`
    width:int
         Width of the image in pixels
    target_value:float [optional]
         Target value. 
    """
    _converter = t.Dict(
        {
            t.Key("height"):  t.Int(),
            t.Key("image_id"):  t.String(),
            t.Key("width"):  t.Int(),
            t.Key("target_value", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        height,
        image_id,
        width,
        target_value=None,
    ):
        self.height = height
        self.image_id = image_id
        self.width = width
        self.target_value = target_value

    def __repr__(self):
        return (
            "ImageMetadataResponse("
            "height={0.height}, "
            "image_id={0.image_id}, "
            "width={0.width}, "
            "target_value={0.target_value}, "
        ).format(self)
