#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ImageMetadataWithBins(APIObject):
    """
    Attributes
    ----------
    height:int
         Height of the image in pixels
    image_id:str
         Id of the image. The actual image file can be retrieved with :http:get:`/api/v2/projects/(projectId)/images/(imageId)/file/`
    target_bin_row_count:int
         Number of rows in this target bin
    width:int
         Width of the image in pixels
    target_bin_end:int, none_type [optional]
         Target value for bin end for regression, null for classification. 
    target_bin_start:int, none_type [optional]
         Target value for bin start for regression, null for classification. 
    target_value:float [optional]
         Target value. 
    """
    _converter = t.Dict(
        {
            t.Key("height"):  t.Int(),
            t.Key("image_id"):  t.String(),
            t.Key("target_bin_row_count"):  t.Int(),
            t.Key("width"):  t.Int(),
            t.Key("target_bin_end", optional=True):  t.Int(),
            t.Key("target_bin_start", optional=True):  t.Int(),
            t.Key("target_value", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        height,
        image_id,
        target_bin_row_count,
        width,
        target_bin_end=None,
        target_bin_start=None,
        target_value=None,
    ):
        self.height = height
        self.image_id = image_id
        self.target_bin_row_count = target_bin_row_count
        self.width = width
        self.target_bin_end = target_bin_end
        self.target_bin_start = target_bin_start
        self.target_value = target_value

    def __repr__(self):
        return (
            "ImageMetadataWithBins("
            "height={0.height}, "
            "image_id={0.image_id}, "
            "target_bin_row_count={0.target_bin_row_count}, "
            "width={0.width}, "
            "target_bin_end={0.target_bin_end}, "
            "target_bin_start={0.target_bin_start}, "
            "target_value={0.target_value}, "
        ).format(self)
