#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ImportedModelRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    created_by_id:str
         ID of the user who originally created the model
    created_by_username:str
         Name of the user who originally created the model
    dataset_name:str
         Filename of the dataset used to create the project
    display_name:str
         Human-readable model import name
    featurelist_name:str
         Name of the featurelist used to train the model
    id:str
         Imported model id
    imported_at:datetime
         datetime the model was imported, RFC 3339 Z Date and Time
    imported_by_id:str
         ID of the user who imported the model
    imported_by_username:str
         Name of the user who imported the model
    is_time_series:bool
         True if this is a timeseries model, otherwise - false
    model_id:str
         Original model ID
    model_name:str
         Human-readable model type
    note:str, none_type
         Manually added note about this model
    origin_url:str
         URL of the application the model was exported from
    project_id:str
         Original project ID the models belongs to
    project_name:str
         Original project name
    python_version:str, none_type
         Version of python runtime used to process this model
    target:str
         Name of the projects target
    version:str
         Original project version (DataRobot app version)
    """
    _converter = t.Dict(
        {
            t.Key("created_by_id"):  t.String(),
            t.Key("created_by_username"):  t.String(),
            t.Key("dataset_name"):  t.String(),
            t.Key("display_name"):  t.String(),
            t.Key("featurelist_name"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("imported_at"):  t.DateTime(),
            t.Key("imported_by_id"):  t.String(),
            t.Key("imported_by_username"):  t.String(),
            t.Key("is_time_series"):  t.Bool(),
            t.Key("model_id"):  t.String(),
            t.Key("model_name"):  t.String(),
            t.Key("note"):  t.String(),
            t.Key("origin_url"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("project_name"):  t.String(),
            t.Key("python_version"):  t.String(),
            t.Key("target"):  t.String(),
            t.Key("version"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created_by_id,
        created_by_username,
        dataset_name,
        display_name,
        featurelist_name,
        id,
        imported_at,
        imported_by_id,
        imported_by_username,
        is_time_series,
        model_id,
        model_name,
        note,
        origin_url,
        project_id,
        project_name,
        python_version,
        target,
        version,
    ):
        self.created_by_id = created_by_id
        self.created_by_username = created_by_username
        self.dataset_name = dataset_name
        self.display_name = display_name
        self.featurelist_name = featurelist_name
        self.id = id
        self.imported_at = imported_at
        self.imported_by_id = imported_by_id
        self.imported_by_username = imported_by_username
        self.is_time_series = is_time_series
        self.model_id = model_id
        self.model_name = model_name
        self.note = note
        self.origin_url = origin_url
        self.project_id = project_id
        self.project_name = project_name
        self.python_version = python_version
        self.target = target
        self.version = version

    def __repr__(self):
        return (
            "ImportedModelRetrieveResponse("
            "created_by_id={0.created_by_id}, "
            "created_by_username={0.created_by_username}, "
            "dataset_name={0.dataset_name}, "
            "display_name={0.display_name}, "
            "featurelist_name={0.featurelist_name}, "
            "id={0.id}, "
            "imported_at={0.imported_at}, "
            "imported_by_id={0.imported_by_id}, "
            "imported_by_username={0.imported_by_username}, "
            "is_time_series={0.is_time_series}, "
            "model_id={0.model_id}, "
            "model_name={0.model_name}, "
            "note={0.note}, "
            "origin_url={0.origin_url}, "
            "project_id={0.project_id}, "
            "project_name={0.project_name}, "
            "python_version={0.python_version}, "
            "target={0.target}, "
            "version={0.version}, "
        ).format(self)
