#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.jdbc_fields import JDBCFields

class JDBCDataStoreUpdate(APIObject):
    """
    Attributes
    ----------
    driver_id:str [optional]
         Driver ID.. 
    jdbc_fields:[JDBCFields] [optional]
         The fields used to create the JDBC URL, in the form of a JSON object where parameter name/value pairs are the items in the object. For example: `{\"address\": localhost:5432, \"database\": \"fooBar\", \"connectTimeout\": 10}`. In most cases, all keys in `jdbcFields` should be defined by a schema listed in `jdbcFieldSchemas` from `DriverConfiguration`. The request will be rejected if there are required parameters (as defined by `jdbcFieldSchemas`) that are not provided.. 
    jdbc_url:str [optional]
         JDBC URL.. 
    """
    _converter = t.Dict(
        {
            t.Key("driver_id", optional=True):  t.String(),
            t.Key("jdbc_fields", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("jdbc_url", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        driver_id=None,
        jdbc_fields=None,
        jdbc_url=None,
    ):
        self.driver_id = driver_id
        self.jdbc_fields = jdbc_fields
        self.jdbc_url = jdbc_url

    def __repr__(self):
        return (
            "JDBCDataStoreUpdate("
            "driver_id={0.driver_id}, "
            "jdbc_fields={0.jdbc_fields}, "
            "jdbc_url={0.jdbc_url}, "
        ).format(self)
