#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class JDBCFieldSchemas(APIObject):
    """
    Attributes
    ----------
    choices:[str]
         If non-empty, a list of all possible values for this parameter.. defaults to []
    default:str
         Default value of the JDBC parameter.
    description:str
         Description of this parameter.. defaults to ""
    kind:str
         Use of this parameter in constructing the JDBC URL.
    name:str
         Name of the JDBC parameter.
    required:bool
         Whether or not the parameter is required for a connection.
    visible_by_default:bool
         Whether or not the parameter should be shown in the UI by default.
    index:int [optional]
         Sort order within one `kind`.. 
    """
    _converter = t.Dict(
        {
            t.Key("choices"):  t.List(t.Dict().allow_extra("*")),
            t.Key("default"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("kind"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("required"):  t.Bool(),
            t.Key("visible_by_default"):  t.Bool(),
            t.Key("index", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        choices,
        default,
        description,
        kind,
        name,
        required,
        visible_by_default,
        index=None,
    ):
        self.choices = choices
        self.default = default
        self.description = description
        self.kind = kind
        self.name = name
        self.required = required
        self.visible_by_default = visible_by_default
        self.index = index

    def __repr__(self):
        return (
            "JDBCFieldSchemas("
            "choices={0.choices}, "
            "default={0.default}, "
            "description={0.description}, "
            "kind={0.kind}, "
            "name={0.name}, "
            "required={0.required}, "
            "visible_by_default={0.visible_by_default}, "
            "index={0.index}, "
        ).format(self)
