#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class JDBCIntake(APIObject):
    """
    Attributes
    ----------
    data_store_id:str
         ID of the data store to connect to
    type:str
         Type name for this intake type. defaults to "jdbc", must be one of ["jdbc", ]
    catalog:str [optional]
         The name of the specified database catalog to read input data from.. 
    credential_id:str, none_type [optional]
         The ID of the credential holding information about a user with read access to the JDBC data source.. 
    fetch_size:int [optional]
         A user specified fetch size. Changing it can be used to balance throughput and memory usage. Deprecated and ignored since v2.21.. 
    query:str [optional]
         A self-supplied SELECT statement of the dataset you wish to score. Helpful for supplying a more fine-grained selection of data not achievable through specification of \"table\" and/or \"schema\" parameters exclusively.If this job is executed with a job definition, then template variables are available which will be substituted for timestamps: {{ current_run_timestamp }}, {{ last_completed_run_time }}, {{ last_scheduled_run_time }}, {{ next_scheduled_run_time }}, {{ current_run_time }}. 
    schema:str [optional]
         The name of the specified database schema to read input data from.. 
    table:str [optional]
         The name of the specified database table to read input data from.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_store_id"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("catalog", optional=True):  t.String(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("fetch_size", optional=True):  t.Int(),
            t.Key("query", optional=True):  t.String(),
            t.Key("schema", optional=True):  t.String(),
            t.Key("table", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_store_id,
        type,
        catalog=None,
        credential_id=None,
        fetch_size=None,
        query=None,
        schema=None,
        table=None,
    ):
        self.data_store_id = data_store_id
        self.type = type
        self.catalog = catalog
        self.credential_id = credential_id
        self.fetch_size = fetch_size
        self.query = query
        self.schema = schema
        self.table = table

    def __repr__(self):
        return (
            "JDBCIntake("
            "data_store_id={0.data_store_id}, "
            "type={0.type}, "
            "catalog={0.catalog}, "
            "credential_id={0.credential_id}, "
            "fetch_size={0.fetch_size}, "
            "query={0.query}, "
            "schema={0.schema}, "
            "table={0.table}, "
        ).format(self)
