#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class JDBCOutput(APIObject):
    """
    Attributes
    ----------
    data_store_id:str
         ID of the data store to connect to
    statement_type:str
         The statement type to use when writing the results. Deprecation Warning: Use of `create_table` is now discouraged. Use one of the other possibilities along with the parameter `createTableIfNotExists` set to `true`.
    table:str
         The name of the specified database table to write the results to.If this job is executed with a job definition, then template variables are available which will be substituted for timestamps: {{ current_run_timestamp }}, {{ last_completed_run_time }}, {{ last_scheduled_run_time }}, {{ next_scheduled_run_time }}, {{ current_run_time }}
    type:str
         Type name for this intake type. defaults to "jdbc", must be one of ["jdbc", ]
    catalog:str [optional]
         The name of the specified database catalog to write output data to.. 
    commit_interval:int [optional]
         Defines a time interval in seconds between each commit is done to the JDBC source. If set to 0, the batch prediction operation will write the entire job before committing..  if omitted the server will use the default value of 600
    create_table_if_not_exists:bool [optional]
         Attempt to create the table first if no existing one is detected, before writing data with the strategy defined in the `statementType` parameter..  if omitted the server will use the default value of False
    credential_id:str, none_type [optional]
         The ID of the credential holding information about a user with write access to the JDBC data source.. 
    schema:str [optional]
         The name of the specified database schema to write the results to.. 
    update_columns:[str] [optional]
         The column names to be updated if statementType is set to either update or upsert.. 
    where_columns:[str] [optional]
         The column names to be used in the where clause if statementType is set to update or upsert.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_store_id"):  t.String(),
            t.Key("statement_type"):  t.String(),
            t.Key("table"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("catalog", optional=True):  t.String(),
            t.Key("commit_interval", optional=True):  t.Int(),
            t.Key("create_table_if_not_exists", optional=True):  t.Bool(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("schema", optional=True):  t.String(),
            t.Key("update_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("where_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_store_id,
        statement_type,
        table,
        type,
        catalog=None,
        commit_interval=None,
        create_table_if_not_exists=None,
        credential_id=None,
        schema=None,
        update_columns=None,
        where_columns=None,
    ):
        self.data_store_id = data_store_id
        self.statement_type = statement_type
        self.table = table
        self.type = type
        self.catalog = catalog
        self.commit_interval = commit_interval
        self.create_table_if_not_exists = create_table_if_not_exists
        self.credential_id = credential_id
        self.schema = schema
        self.update_columns = update_columns
        self.where_columns = where_columns

    def __repr__(self):
        return (
            "JDBCOutput("
            "data_store_id={0.data_store_id}, "
            "statement_type={0.statement_type}, "
            "table={0.table}, "
            "type={0.type}, "
            "catalog={0.catalog}, "
            "commit_interval={0.commit_interval}, "
            "create_table_if_not_exists={0.create_table_if_not_exists}, "
            "credential_id={0.credential_id}, "
            "schema={0.schema}, "
            "update_columns={0.update_columns}, "
            "where_columns={0.where_columns}, "
        ).format(self)
