#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class JDBCQueryDataSource(APIObject):
    """
    Attributes
    ----------
    data_store_id:str
         Data store ID for this data source.
    query:str
         The user-specified SQL query. If this is used, then catalog, schema and table will not be used.
    fetch_size:int [optional]
         User-specified fetch size.. 
    """
    _converter = t.Dict(
        {
            t.Key("data_store_id"):  t.String(),
            t.Key("query"):  t.String(),
            t.Key("fetch_size", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data_store_id,
        query,
        fetch_size=None,
    ):
        self.data_store_id = data_store_id
        self.query = query
        self.fetch_size = fetch_size

    def __repr__(self):
        return (
            "JDBCQueryDataSource("
            "data_store_id={0.data_store_id}, "
            "query={0.query}, "
            "fetch_size={0.fetch_size}, "
        ).format(self)
