#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.job_details_response import JobDetailsResponse

class JobListResponse(APIObject):
    """
    Attributes
    ----------
    count:int
         the number of jobs returned.
    jobs:[JobDetailsResponse]
         A json array of jobs
    next:str, none_type
         URL pointing to the next page (if null, there is no next page).
    previous:str, none_type
         URL pointing to the previous page (if null, there is no previous page).
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("jobs"):  t.List(t.Dict().allow_extra("*")),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        jobs,
        next,
        previous,
    ):
        self.count = count
        self.jobs = jobs
        self.next = next
        self.previous = previous

    def __repr__(self):
        return (
            "JobListResponse("
            "count={0.count}, "
            "jobs={0.jobs}, "
            "next={0.next}, "
            "previous={0.previous}, "
        ).format(self)
