#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class JobRunDetails(APIObject):
    """
    Attributes
    ----------
    completed:datetime, none_type
         The time this job instance completed in ISO UTC format (e.g. '2020-02-20T18:00:02.218000Z')
    created:datetime
         The time this job instance was created in ISO UTC format (e.g. '2020-02-20T18:00:02.218000Z')
    duration:int, none_type
         The number of seconds this job took to be completed
    failed:datetime, none_type
         The time this job instance failed in ISO UTC format (e.g. '2020-02-20T18:00:02.218000Z')
    failed_rows:int
         The number of rows that failed to score correctly
    job_run_id:str
         The ID of the job run. Used for accessing log information
    job_status:str
         The current status of the job
    scored_rows:int
         The number of rows that were successfully scored
    total_rows:int
         The number of rows that were processed
    """
    _converter = t.Dict(
        {
            t.Key("completed"):  t.DateTime(),
            t.Key("created"):  t.DateTime(),
            t.Key("duration"):  t.Int(),
            t.Key("failed"):  t.DateTime(),
            t.Key("failed_rows"):  t.Int(),
            t.Key("job_run_id"):  t.String(),
            t.Key("job_status"):  t.String(),
            t.Key("scored_rows"):  t.Int(),
            t.Key("total_rows"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        completed,
        created,
        duration,
        failed,
        failed_rows,
        job_run_id,
        job_status,
        scored_rows,
        total_rows,
    ):
        self.completed = completed
        self.created = created
        self.duration = duration
        self.failed = failed
        self.failed_rows = failed_rows
        self.job_run_id = job_run_id
        self.job_status = job_status
        self.scored_rows = scored_rows
        self.total_rows = total_rows

    def __repr__(self):
        return (
            "JobRunDetails("
            "completed={0.completed}, "
            "created={0.created}, "
            "duration={0.duration}, "
            "failed={0.failed}, "
            "failed_rows={0.failed_rows}, "
            "job_run_id={0.job_run_id}, "
            "job_status={0.job_status}, "
            "scored_rows={0.scored_rows}, "
            "total_rows={0.total_rows}, "
        ).format(self)
