#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class LiftChartbins(APIObject):
    """
    Attributes
    ----------
    actual:float
         The average of the actual target values for the rows in the bin.
    bin_weight:float
         How much data is in the bin. For projects with weights, it is the sum of the weights of all rows in the bins; otherwise, it is the number of rows in the bin.
    predicted:float
         The average of predicted values of the target for the rows in the bin.
    """
    _converter = t.Dict(
        {
            t.Key("actual"):  t.Float(),
            t.Key("bin_weight"):  t.Float(),
            t.Key("predicted"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual,
        bin_weight,
        predicted,
    ):
        self.actual = actual
        self.bin_weight = bin_weight
        self.predicted = predicted

    def __repr__(self):
        return (
            "LiftChartbins("
            "actual={0.actual}, "
            "bin_weight={0.bin_weight}, "
            "predicted={0.predicted}, "
        ).format(self)
