#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.lift_chartbins import LiftChartbins

class LiftData(APIObject):
    """
    Attributes
    ----------
    bins:[LiftChartbins]
         The lift chart data for that source, as specified below.
    dataset_id:str
         The dataset id of dataset which was used to compute Lift chart.
    """
    _converter = t.Dict(
        {
            t.Key("bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("dataset_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        bins,
        dataset_id,
    ):
        self.bins = bins
        self.dataset_id = dataset_id

    def __repr__(self):
        return (
            "LiftData("
            "bins={0.bins}, "
            "dataset_id={0.dataset_id}, "
        ).format(self)
