#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.user_in_group import UserInGroup

class ListUsersInGroupResponse(APIObject):
    """
    Attributes
    ----------
    count:int
         The number of items returned on this page.
    data:[UserInGroup]
         List of users in the group.
    next:str, none_type
         The URL to the next page.
    previous:str, none_type
         The URL to the previous page.
    total_count:int
         The total number of items that match the query condition.
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("total_count"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        data,
        next,
        previous,
        total_count,
    ):
        self.count = count
        self.data = data
        self.next = next
        self.previous = previous
        self.total_count = total_count

    def __repr__(self):
        return (
            "ListUsersInGroupResponse("
            "count={0.count}, "
            "data={0.data}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "total_count={0.total_count}, "
        ).format(self)
