#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.tuning_parameter import TuningParameter

class ModelAdvancedTuning(APIObject):
    """
    Attributes
    ----------
    tuning_parameters:[TuningParameter]
         Parameters to tune.
    tuning_description:str [optional]
         Human-readable description of this advanced-tuning request.. 
    """
    _converter = t.Dict(
        {
            t.Key("tuning_parameters"):  t.List(t.Dict().allow_extra("*")),
            t.Key("tuning_description", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        tuning_parameters,
        tuning_description=None,
    ):
        self.tuning_parameters = tuning_parameters
        self.tuning_description = tuning_description

    def __repr__(self):
        return (
            "ModelAdvancedTuning("
            "tuning_parameters={0.tuning_parameters}, "
            "tuning_description={0.tuning_description}, "
        ).format(self)
