#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.reasons import Reasons

class ModelCapabilitiesRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    eligible_for_prime:bool
         `True` if the model is eligible for prime. Use :http:get:`/api/v2/projects/(projectId)/models/(modelId)/primeInfo/` to request additional details if the model is not eligible.
    has_parameters:bool
         `True` if the model has parameters that can be retrieved. Use :http:get:`/api/v2/projects/(projectId)/models/(modelId)/parameters/` to retrieve the model parameters.
    has_word_cloud:bool
         True` if the model has word cloud data available. Use :http:get:`/api/v2/projects/(projectId)/models/(modelId)/wordCloud/` to retrieve a word cloud.
    supports_blending:bool
         `True` if the model supports blending. See :http:post:`/api/v2/projects/(projectId)/blenderModels/blendCheck/` to check specific blending combinations.
    supports_code_generation:bool
         `True` if the model supports export of model's source code or compiled Java executable.
    supports_image_activation_maps:bool
         `True` if the model has image column(s) and activation maps can be generated.
    supports_image_embedding:bool
         `True` if the model has image column(s) and image embeddings can be generated.
    supports_model_training_metrics:bool
         When `True` , the model will track and save key training metrics in an effort to communicate model accuracy throughout training, rather than at training completion.
    supports_monotonic_constraints:bool
         `True` if the model supports monotonic  constraints.
    supports_nn_visualizations:bool
         `True` if the model supports neuralNetworkVisualizations.
    supports_shap:bool
         `True` if the model supports Shapley package. i.e. Shapley based feature Importance
    reasons:Reasons [optional]
         
    supports_early_stopping:bool [optional]
         `True` if this is an early stopping tree-based model and number of trained iterations can be retrieved.. 
    supports_model_package_export:bool [optional]
         `True` if the model can be exported as a model package.. 
    """
    _converter = t.Dict(
        {
            t.Key("eligible_for_prime"):  t.Bool(),
            t.Key("has_parameters"):  t.Bool(),
            t.Key("has_word_cloud"):  t.Bool(),
            t.Key("supports_blending"):  t.Bool(),
            t.Key("supports_code_generation"):  t.Bool(),
            t.Key("supports_image_activation_maps"):  t.Bool(),
            t.Key("supports_image_embedding"):  t.Bool(),
            t.Key("supports_model_training_metrics"):  t.Bool(),
            t.Key("supports_monotonic_constraints"):  t.Bool(),
            t.Key("supports_nn_visualizations"):  t.Bool(),
            t.Key("supports_shap"):  t.Bool(),
            t.Key("reasons", optional=True):  t.Any(),
            t.Key("supports_early_stopping", optional=True):  t.Bool(),
            t.Key("supports_model_package_export", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        eligible_for_prime,
        has_parameters,
        has_word_cloud,
        supports_blending,
        supports_code_generation,
        supports_image_activation_maps,
        supports_image_embedding,
        supports_model_training_metrics,
        supports_monotonic_constraints,
        supports_nn_visualizations,
        supports_shap,
        reasons=None,
        supports_early_stopping=None,
        supports_model_package_export=None,
    ):
        self.eligible_for_prime = eligible_for_prime
        self.has_parameters = has_parameters
        self.has_word_cloud = has_word_cloud
        self.supports_blending = supports_blending
        self.supports_code_generation = supports_code_generation
        self.supports_image_activation_maps = supports_image_activation_maps
        self.supports_image_embedding = supports_image_embedding
        self.supports_model_training_metrics = supports_model_training_metrics
        self.supports_monotonic_constraints = supports_monotonic_constraints
        self.supports_nn_visualizations = supports_nn_visualizations
        self.supports_shap = supports_shap
        self.reasons = reasons
        self.supports_early_stopping = supports_early_stopping
        self.supports_model_package_export = supports_model_package_export

    def __repr__(self):
        return (
            "ModelCapabilitiesRetrieveResponse("
            "eligible_for_prime={0.eligible_for_prime}, "
            "has_parameters={0.has_parameters}, "
            "has_word_cloud={0.has_word_cloud}, "
            "supports_blending={0.supports_blending}, "
            "supports_code_generation={0.supports_code_generation}, "
            "supports_image_activation_maps={0.supports_image_activation_maps}, "
            "supports_image_embedding={0.supports_image_embedding}, "
            "supports_model_training_metrics={0.supports_model_training_metrics}, "
            "supports_monotonic_constraints={0.supports_monotonic_constraints}, "
            "supports_nn_visualizations={0.supports_nn_visualizations}, "
            "supports_shap={0.supports_shap}, "
            "reasons={0.reasons}, "
            "supports_early_stopping={0.supports_early_stopping}, "
            "supports_model_package_export={0.supports_model_package_export}, "
        ).format(self)
