#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.actual_frequency import ActualFrequency
from datarobot.models.full_api.generated.model.predicted_frequency import PredictedFrequency

class ModelConfusionChartClassDetailsForDatasetRetrieve(APIObject):
    """
    Attributes
    ----------
    actual_frequency:[ActualFrequency]
         One vs All actual percentage and count in a format specified below sorted by percentage in decreasing order
    class_name:str
         Name of a class for which distribution frequency is requested
    dataset_id:str
         The dataset to retrieve a Confusion chart from.
    model_id:str
         The model to retrieve a Confusion chart from.
    predicted_frequency:[PredictedFrequency]
         One vs All predicted percentage and count in a format specified below sorted by percentage in decreasing order
    project_id:str
         The project to retrieve a Confusion chart from.
    """
    _converter = t.Dict(
        {
            t.Key("actual_frequency"):  t.List(t.Dict().allow_extra("*")),
            t.Key("class_name"):  t.String(),
            t.Key("dataset_id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("predicted_frequency"):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual_frequency,
        class_name,
        dataset_id,
        model_id,
        predicted_frequency,
        project_id,
    ):
        self.actual_frequency = actual_frequency
        self.class_name = class_name
        self.dataset_id = dataset_id
        self.model_id = model_id
        self.predicted_frequency = predicted_frequency
        self.project_id = project_id

    def __repr__(self):
        return (
            "ModelConfusionChartClassDetailsForDatasetRetrieve("
            "actual_frequency={0.actual_frequency}, "
            "class_name={0.class_name}, "
            "dataset_id={0.dataset_id}, "
            "model_id={0.model_id}, "
            "predicted_frequency={0.predicted_frequency}, "
            "project_id={0.project_id}, "
        ).format(self)
