#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.actual_frequency import ActualFrequency
from datarobot.models.full_api.generated.model.predicted_frequency import PredictedFrequency

class ModelConfusionChartClassDetailsRetrieveReponseController(APIObject):
    """
    Attributes
    ----------
    actual_frequency:[ActualFrequency]
         One vs all actual percentage and count in a format specified below sorted by percentage in decreasing order
    class_name:str
         Name of a class for which distribution frequency is requested.
    predicted_frequency:[PredictedFrequency]
         One vs all predicted percentage and count in a format specified below sorted by percentage in decreasing order
    """
    _converter = t.Dict(
        {
            t.Key("actual_frequency"):  t.List(t.Dict().allow_extra("*")),
            t.Key("class_name"):  t.String(),
            t.Key("predicted_frequency"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual_frequency,
        class_name,
        predicted_frequency,
    ):
        self.actual_frequency = actual_frequency
        self.class_name = class_name
        self.predicted_frequency = predicted_frequency

    def __repr__(self):
        return (
            "ModelConfusionChartClassDetailsRetrieveReponseController("
            "actual_frequency={0.actual_frequency}, "
            "class_name={0.class_name}, "
            "predicted_frequency={0.predicted_frequency}, "
        ).format(self)
