#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelConfusionChartMetadataRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    class_names:[str]
         List of all class names in the full confusion matrix, sorted by the `orderBy` parameter
    relevant_classes_positions:[[int]]
         Matrix to highlight important cell blocks in the confusion chart.  Intended to represent a thumbnail view, where the relevantClassesPositions array has a 1 in thumbnail cells that are of interest, and 0 otherwise.  The dimensions of the implied thumbnail will not match those of the confusion matrix, e.g. a twenty-class confusion matrix may have a 2x2 thumbnail.
    source:str
         Source of the chart.
    total_matrix_sum:int
         Sum of all values in the full confusion matrix (equal to the number of points considered)
    """
    _converter = t.Dict(
        {
            t.Key("class_names"):  t.List(t.Dict().allow_extra("*")),
            t.Key("relevant_classes_positions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("source"):  t.String(),
            t.Key("total_matrix_sum"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_names,
        relevant_classes_positions,
        source,
        total_matrix_sum,
    ):
        self.class_names = class_names
        self.relevant_classes_positions = relevant_classes_positions
        self.source = source
        self.total_matrix_sum = total_matrix_sum

    def __repr__(self):
        return (
            "ModelConfusionChartMetadataRetrieveResponse("
            "class_names={0.class_names}, "
            "relevant_classes_positions={0.relevant_classes_positions}, "
            "source={0.source}, "
            "total_matrix_sum={0.total_matrix_sum}, "
        ).format(self)
