#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelExport(APIObject):
    """
    Attributes
    ----------
    model_id:str
         The model ID
    project_id:str
         The project ID
    percentile:int [optional]
         For supervised time series projects only. Indicates the percentile used for prediction intervals calculation.. 
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("percentile", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        project_id,
        percentile=None,
    ):
        self.model_id = model_id
        self.project_id = project_id
        self.percentile = percentile

    def __repr__(self):
        return (
            "ModelExport("
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "percentile={0.percentile}, "
        ).format(self)
