#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelJobResponse(APIObject):
    """
    Attributes
    ----------
    blueprint_id:str
         The blueprint used by the model - note that this is not an ObjectId.
    featurelist_id:str
         The ID of the featurelist the model is using.
    id:str
         The job ID.
    is_blocked:bool
         True if a job is waiting for its dependencies to be resolved first.
    model_category:str
         Indicates what kind of model this is. Will be ``combined`` for combined models.
    model_id:str
         The ID of the model
    model_type:str
         The type of model used by the job.
    processes:[str]
         List of processes the modeling job includes
    project_id:str
         The project the job belongs to.
    sample_pct:float
         The percentage of the dataset the job is using.
    status:str
         The status of the job.
    """
    _converter = t.Dict(
        {
            t.Key("blueprint_id"):  t.String(),
            t.Key("featurelist_id"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("is_blocked"):  t.Bool(),
            t.Key("model_category"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("model_type"):  t.String(),
            t.Key("processes"):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_id"):  t.String(),
            t.Key("sample_pct"):  t.Float(),
            t.Key("status"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blueprint_id,
        featurelist_id,
        id,
        is_blocked,
        model_category,
        model_id,
        model_type,
        processes,
        project_id,
        sample_pct,
        status,
    ):
        self.blueprint_id = blueprint_id
        self.featurelist_id = featurelist_id
        self.id = id
        self.is_blocked = is_blocked
        self.model_category = model_category
        self.model_id = model_id
        self.model_type = model_type
        self.processes = processes
        self.project_id = project_id
        self.sample_pct = sample_pct
        self.status = status

    def __repr__(self):
        return (
            "ModelJobResponse("
            "blueprint_id={0.blueprint_id}, "
            "featurelist_id={0.featurelist_id}, "
            "id={0.id}, "
            "is_blocked={0.is_blocked}, "
            "model_category={0.model_category}, "
            "model_id={0.model_id}, "
            "model_type={0.model_type}, "
            "processes={0.processes}, "
            "project_id={0.project_id}, "
            "sample_pct={0.sample_pct}, "
            "status={0.status}, "
        ).format(self)
