#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageCapabilities(APIObject):
    """
    Attributes
    ----------
    supports_challenger_models:bool
         Whether Challenger Models are supported by this model package.
    supports_feature_drift_tracking:bool
         Whether Feature Drift is supported by this model package.
    supports_humility_recommended_rules:bool
         Whether calculating values for recommended Humility Rules is supported by this model package.
    supports_humility_rules:bool
         Whether Humility Rules are supported by this model package.
    supports_humility_rules_default_calculations:bool
         Whether calculating default values for Humility Rules is supported by this model package.
    supports_prediction_warning:bool
         Whether Prediction Warnings are supported by this model package.
    supports_segmented_analysis_drift_and_accuracy:bool
         Whether tracking features in training and predictions data for segmented analysis is supported by this model package.
    supports_shap_based_prediction_explanations:bool
         Whether shap-based prediction explanations are supported by this model package.
    supports_target_drift_tracking:bool
         Whether Target Drift is supported by this model package.
    supports_automatic_actuals:bool [optional]
         Whether inferring actual values from time series history data and automatically feeding them back for accuracy estimation is supported by this model package.. 
    supports_scoring_code_download:bool [optional]
         Whether scoring code download is supported by this model package.. 
    """
    _converter = t.Dict(
        {
            t.Key("supports_challenger_models"):  t.Bool(),
            t.Key("supports_feature_drift_tracking"):  t.Bool(),
            t.Key("supports_humility_recommended_rules"):  t.Bool(),
            t.Key("supports_humility_rules"):  t.Bool(),
            t.Key("supports_humility_rules_default_calculations"):  t.Bool(),
            t.Key("supports_prediction_warning"):  t.Bool(),
            t.Key("supports_segmented_analysis_drift_and_accuracy"):  t.Bool(),
            t.Key("supports_shap_based_prediction_explanations"):  t.Bool(),
            t.Key("supports_target_drift_tracking"):  t.Bool(),
            t.Key("supports_automatic_actuals", optional=True):  t.Bool(),
            t.Key("supports_scoring_code_download", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        supports_challenger_models,
        supports_feature_drift_tracking,
        supports_humility_recommended_rules,
        supports_humility_rules,
        supports_humility_rules_default_calculations,
        supports_prediction_warning,
        supports_segmented_analysis_drift_and_accuracy,
        supports_shap_based_prediction_explanations,
        supports_target_drift_tracking,
        supports_automatic_actuals=None,
        supports_scoring_code_download=None,
    ):
        self.supports_challenger_models = supports_challenger_models
        self.supports_feature_drift_tracking = supports_feature_drift_tracking
        self.supports_humility_recommended_rules = supports_humility_recommended_rules
        self.supports_humility_rules = supports_humility_rules
        self.supports_humility_rules_default_calculations = supports_humility_rules_default_calculations
        self.supports_prediction_warning = supports_prediction_warning
        self.supports_segmented_analysis_drift_and_accuracy = supports_segmented_analysis_drift_and_accuracy
        self.supports_shap_based_prediction_explanations = supports_shap_based_prediction_explanations
        self.supports_target_drift_tracking = supports_target_drift_tracking
        self.supports_automatic_actuals = supports_automatic_actuals
        self.supports_scoring_code_download = supports_scoring_code_download

    def __repr__(self):
        return (
            "ModelPackageCapabilities("
            "supports_challenger_models={0.supports_challenger_models}, "
            "supports_feature_drift_tracking={0.supports_feature_drift_tracking}, "
            "supports_humility_recommended_rules={0.supports_humility_recommended_rules}, "
            "supports_humility_rules={0.supports_humility_rules}, "
            "supports_humility_rules_default_calculations={0.supports_humility_rules_default_calculations}, "
            "supports_prediction_warning={0.supports_prediction_warning}, "
            "supports_segmented_analysis_drift_and_accuracy={0.supports_segmented_analysis_drift_and_accuracy}, "
            "supports_shap_based_prediction_explanations={0.supports_shap_based_prediction_explanations}, "
            "supports_target_drift_tracking={0.supports_target_drift_tracking}, "
            "supports_automatic_actuals={0.supports_automatic_actuals}, "
            "supports_scoring_code_download={0.supports_scoring_code_download}, "
        ).format(self)
