#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageCreateFromLearningModel(APIObject):
    """
    Attributes
    ----------
    model_id:str
         ID of the DataRobot model.
    name:str, none_type [optional]
         Name of the model package..  if omitted the server will use the default value of "null"
    prediction_threshold:float [optional]
         Threshold used for binary classification in predictions. 
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("name", optional=True):  t.String(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        name=None,
        prediction_threshold=None,
    ):
        self.model_id = model_id
        self.name = name
        self.prediction_threshold = prediction_threshold

    def __repr__(self):
        return (
            "ModelPackageCreateFromLearningModel("
            "model_id={0.model_id}, "
            "name={0.name}, "
            "prediction_threshold={0.prediction_threshold}, "
        ).format(self)
