#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageDatasets(APIObject):
    """
    Attributes
    ----------
    baseline_segmented_by:[str], none_type
         Names of categorical features by which the training baseline was segmented. This allows for deployment prediction requests to be segmented by those same features. Segmenting the training baseline by these features allows for users to perform segmented analysis of Data Drift and Accuracy, and to compare the same subset of training and scoring data based on the selected segment attribute and segment value.
    dataset_name:str, none_type
         Name of dataset used to train the model
    holdout_data_catalog_id:str, none_type
         ID for holdout data (returned from uploading a data set)
    holdout_dataset_name:str, none_type
         Name of dataset used for model holdout
    training_data_catalog_id:str, none_type
         ID for training data (returned from uploading a data set)
    target_histogram_baseline:str [optional]
         Values used to establish the training baseline. 
    training_data_size:int [optional]
         Number of rows in training data (used by DR models). 
    """
    _converter = t.Dict(
        {
            t.Key("baseline_segmented_by"):  t.List(t.Dict().allow_extra("*")),
            t.Key("dataset_name"):  t.String(),
            t.Key("holdout_data_catalog_id"):  t.String(),
            t.Key("holdout_dataset_name"):  t.String(),
            t.Key("training_data_catalog_id"):  t.String(),
            t.Key("target_histogram_baseline", optional=True):  t.String(),
            t.Key("training_data_size", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        baseline_segmented_by,
        dataset_name,
        holdout_data_catalog_id,
        holdout_dataset_name,
        training_data_catalog_id,
        target_histogram_baseline=None,
        training_data_size=None,
    ):
        self.baseline_segmented_by = baseline_segmented_by
        self.dataset_name = dataset_name
        self.holdout_data_catalog_id = holdout_data_catalog_id
        self.holdout_dataset_name = holdout_dataset_name
        self.training_data_catalog_id = training_data_catalog_id
        self.target_histogram_baseline = target_histogram_baseline
        self.training_data_size = training_data_size

    def __repr__(self):
        return (
            "ModelPackageDatasets("
            "baseline_segmented_by={0.baseline_segmented_by}, "
            "dataset_name={0.dataset_name}, "
            "holdout_data_catalog_id={0.holdout_data_catalog_id}, "
            "holdout_dataset_name={0.holdout_dataset_name}, "
            "training_data_catalog_id={0.training_data_catalog_id}, "
            "target_histogram_baseline={0.target_histogram_baseline}, "
            "training_data_size={0.training_data_size}, "
        ).format(self)
