#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageImportMeta(APIObject):
    """
    Attributes
    ----------
    creator_id:str
         User ID of the person who created this Model Package
    creator_username:str
         Username of the person who created this model package
    date_created:str
         When this Model Package was created
    original_file_name:str, none_type
         Exists for imported models only, the original file name that was uploaded
    """
    _converter = t.Dict(
        {
            t.Key("creator_id"):  t.String(),
            t.Key("creator_username"):  t.String(),
            t.Key("date_created"):  t.String(),
            t.Key("original_file_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        creator_id,
        creator_username,
        date_created,
        original_file_name,
    ):
        self.creator_id = creator_id
        self.creator_username = creator_username
        self.date_created = date_created
        self.original_file_name = original_file_name

    def __repr__(self):
        return (
            "ModelPackageImportMeta("
            "creator_id={0.creator_id}, "
            "creator_username={0.creator_username}, "
            "date_created={0.date_created}, "
            "original_file_name={0.original_file_name}, "
        ).format(self)
