#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageModelDescription(APIObject):
    """
    Attributes
    ----------
    build_environment_type:str
         build environment type of the model
    description:str, none_type
         a description of the model
    location:str, none_type
         location of the model
    model_name:str [optional]
         model name. 
    """
    _converter = t.Dict(
        {
            t.Key("build_environment_type"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("location"):  t.String(),
            t.Key("model_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        build_environment_type,
        description,
        location,
        model_name=None,
    ):
        self.build_environment_type = build_environment_type
        self.description = description
        self.location = location
        self.model_name = model_name

    def __repr__(self):
        return (
            "ModelPackageModelDescription("
            "build_environment_type={0.build_environment_type}, "
            "description={0.description}, "
            "location={0.location}, "
            "model_name={0.model_name}, "
        ).format(self)
