#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageModelKind(APIObject):
    """
    Attributes
    ----------
    is_anomaly_detection_model:bool
         true if this is an anomaly detection model
    is_decision_flow:bool
         true if this is a decision flow
    is_feature_discovery:bool
         true if this model uses the Feature Discovery feature
    is_multiseries:bool
         true if model is multiseries
    is_time_series:bool
         true if model is time series
    is_unsupervised_learning:bool
         true if model used unsupervised learning
    """
    _converter = t.Dict(
        {
            t.Key("is_anomaly_detection_model"):  t.Bool(),
            t.Key("is_decision_flow"):  t.Bool(),
            t.Key("is_feature_discovery"):  t.Bool(),
            t.Key("is_multiseries"):  t.Bool(),
            t.Key("is_time_series"):  t.Bool(),
            t.Key("is_unsupervised_learning"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        is_anomaly_detection_model,
        is_decision_flow,
        is_feature_discovery,
        is_multiseries,
        is_time_series,
        is_unsupervised_learning,
    ):
        self.is_anomaly_detection_model = is_anomaly_detection_model
        self.is_decision_flow = is_decision_flow
        self.is_feature_discovery = is_feature_discovery
        self.is_multiseries = is_multiseries
        self.is_time_series = is_time_series
        self.is_unsupervised_learning = is_unsupervised_learning

    def __repr__(self):
        return (
            "ModelPackageModelKind("
            "is_anomaly_detection_model={0.is_anomaly_detection_model}, "
            "is_decision_flow={0.is_decision_flow}, "
            "is_feature_discovery={0.is_feature_discovery}, "
            "is_multiseries={0.is_multiseries}, "
            "is_time_series={0.is_time_series}, "
            "is_unsupervised_learning={0.is_unsupervised_learning}, "
        ).format(self)
