#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.model_package_capabilities import ModelPackageCapabilities
from datarobot.models.full_api.generated.model.model_package_datasets import ModelPackageDatasets
from datarobot.models.full_api.generated.model.model_package_import_meta import ModelPackageImportMeta
from datarobot.models.full_api.generated.model.model_package_model_description import ModelPackageModelDescription
from datarobot.models.full_api.generated.model.model_package_model_kind import ModelPackageModelKind
from datarobot.models.full_api.generated.model.model_package_source_meta import ModelPackageSourceMeta
from datarobot.models.full_api.generated.model.model_package_target import ModelPackageTarget
from datarobot.models.full_api.generated.model.model_package_timeseries import ModelPackageTimeseries

class ModelPackageRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    active_deployment_count:int
         Number of deployments currently using this model package
    capabilities:ModelPackageCapabilities
        
    datasets:ModelPackageDatasets
        
    id:str
         ID of the Model package
    import_meta:ModelPackageImportMeta
        
    is_archived:bool
         Whether the model package is permanently archived (cannot be used in deployment or replacement)
    model_description:ModelPackageModelDescription
        
    model_execution_type:str
         Type of model package. `dedicated` (native DataRobot models) and `custom_inference_model` (user added inference models) both execute on DataRobot prediction servers, `external` do not
    model_id:str
         ID of the model
    model_kind:ModelPackageModelKind
        
    name:str
         Model package name
    permissions:[str]
         List of action permissions the user making the request has on the model package
    source_meta:ModelPackageSourceMeta
        
    target:ModelPackageTarget
        
    timeseries:ModelPackageTimeseries
        
    """
    _converter = t.Dict(
        {
            t.Key("active_deployment_count"):  t.Int(),
            t.Key("capabilities"):  t.Any(),
            t.Key("datasets"):  t.Any(),
            t.Key("id"):  t.String(),
            t.Key("import_meta"):  t.Any(),
            t.Key("is_archived"):  t.Bool(),
            t.Key("model_description"):  t.Any(),
            t.Key("model_execution_type"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("model_kind"):  t.Any(),
            t.Key("name"):  t.String(),
            t.Key("permissions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("source_meta"):  t.Any(),
            t.Key("target"):  t.Any(),
            t.Key("timeseries"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        active_deployment_count,
        capabilities,
        datasets,
        id,
        import_meta,
        is_archived,
        model_description,
        model_execution_type,
        model_id,
        model_kind,
        name,
        permissions,
        source_meta,
        target,
        timeseries,
    ):
        self.active_deployment_count = active_deployment_count
        self.capabilities = capabilities
        self.datasets = datasets
        self.id = id
        self.import_meta = import_meta
        self.is_archived = is_archived
        self.model_description = model_description
        self.model_execution_type = model_execution_type
        self.model_id = model_id
        self.model_kind = model_kind
        self.name = name
        self.permissions = permissions
        self.source_meta = source_meta
        self.target = target
        self.timeseries = timeseries

    def __repr__(self):
        return (
            "ModelPackageRetrieveResponse("
            "active_deployment_count={0.active_deployment_count}, "
            "capabilities={0.capabilities}, "
            "datasets={0.datasets}, "
            "id={0.id}, "
            "import_meta={0.import_meta}, "
            "is_archived={0.is_archived}, "
            "model_description={0.model_description}, "
            "model_execution_type={0.model_execution_type}, "
            "model_id={0.model_id}, "
            "model_kind={0.model_kind}, "
            "name={0.name}, "
            "permissions={0.permissions}, "
            "source_meta={0.source_meta}, "
            "target={0.target}, "
            "timeseries={0.timeseries}, "
        ).format(self)
