#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.model_pacakge_scoring_code_meta import ModelPacakgeScoringCodeMeta

class ModelPackageSourceMeta(APIObject):
    """
    Attributes
    ----------
    decision_flow_id:str, none_type
         The ID of the flow associated with this model package
    decision_flow_version_id:str, none_type
         The version ID of the flow associated with this model package
    environment_url:str, none_type
         If available, URL of the source model
    project_id:str, none_type
         If available, the project id used for this model
    project_name:str, none_type
         If available, the project name for this model
    scoring_code:ModelPacakgeScoringCodeMeta
        
    """
    _converter = t.Dict(
        {
            t.Key("decision_flow_id"):  t.String(),
            t.Key("decision_flow_version_id"):  t.String(),
            t.Key("environment_url"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("project_name"):  t.String(),
            t.Key("scoring_code"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        decision_flow_id,
        decision_flow_version_id,
        environment_url,
        project_id,
        project_name,
        scoring_code,
    ):
        self.decision_flow_id = decision_flow_id
        self.decision_flow_version_id = decision_flow_version_id
        self.environment_url = environment_url
        self.project_id = project_id
        self.project_name = project_name
        self.scoring_code = scoring_code

    def __repr__(self):
        return (
            "ModelPackageSourceMeta("
            "decision_flow_id={0.decision_flow_id}, "
            "decision_flow_version_id={0.decision_flow_version_id}, "
            "environment_url={0.environment_url}, "
            "project_id={0.project_id}, "
            "project_name={0.project_name}, "
            "scoring_code={0.scoring_code}, "
        ).format(self)
