#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageTarget(APIObject):
    """
    Attributes
    ----------
    class_count:int, none_type
         Number of classes for classification models.
    class_names:[str], none_type
         Class names for prediction results. When target type is Binary, two class names are returned. The first element is the minority (positive) class and the second element is the majority (negative) class. Limited to 100 returned for Multiclass.
    name:str
         name of the target column
    prediction_probabilities_column:str, none_type
         Field or column name containing prediction probabilities
    prediction_threshold:float, none_type
         Prediction threshold used for binary classification models
    type:str
         Target type of the model.
    """
    _converter = t.Dict(
        {
            t.Key("class_count"):  t.Int(),
            t.Key("class_names"):  t.List(t.Dict().allow_extra("*")),
            t.Key("name"):  t.String(),
            t.Key("prediction_probabilities_column"):  t.String(),
            t.Key("prediction_threshold"):  t.Float(),
            t.Key("type"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_count,
        class_names,
        name,
        prediction_probabilities_column,
        prediction_threshold,
        type,
    ):
        self.class_count = class_count
        self.class_names = class_names
        self.name = name
        self.prediction_probabilities_column = prediction_probabilities_column
        self.prediction_threshold = prediction_threshold
        self.type = type

    def __repr__(self):
        return (
            "ModelPackageTarget("
            "class_count={0.class_count}, "
            "class_names={0.class_names}, "
            "name={0.name}, "
            "prediction_probabilities_column={0.prediction_probabilities_column}, "
            "prediction_threshold={0.prediction_threshold}, "
            "type={0.type}, "
        ).format(self)
