#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelPackageTimeseries(APIObject):
    """
    Attributes
    ----------
    datetime_column_format:str, none_type
         Date format for forecast date and forecast point column
    datetime_column_name:str, none_type
         Name of the forecast date column
    effective_feature_derivation_window_end:int, none_type
         Same concept as `featureDerivationWindowEnd` which is chosen by the user and based on the initial sampled data from the eda sample. When the dataset goes through aim, the pipeline reads the full dataset and figures out the \"real\" FDW (i.e., the effective FDW). For most models, eFDW is approximately the same as the FDW.
    effective_feature_derivation_window_start:int, none_type
         Same concept as `featureDerivationWindowStart` which is chosen by the user and based on the initial sampled data from the eda sample. When the dataset goes through aim, the pipeline reads the full dataset and figures out the \"real\" FDW (i.e., the effective FDW). For most models, eFDW is approximately the same as the FDW.
    feature_derivation_window_end:int, none_type
         Negative number or zero defining how many time units of the forecast distances time unit into the past relative to the forecast point the feature derivation window should end.
    feature_derivation_window_start:int, none_type
         Negative number or zero defining how many time units of the forecast distances time unit into the past relative to the forecast point the feature derivation window should begin.
    forecast_distance_column_name:str, none_type
         Name of the forecast distance column
    forecast_distances:[int], none_type
         List of integer forecast distances
    forecast_distances_time_unit:str, none_type
         The time unit of forecast distances
    forecast_point_column_name:str, none_type
         Name of the forecast point column
    is_cross_series:bool, none_type
         true if the model is cross-series.
    is_new_series_support:bool, none_type
         true if the model is optimized to support new series.
    is_traditional_time_series:bool, none_type
         true if the model is traditional time series.
    series_column_name:str, none_type
         Name of the series column in case of multi-series date
    """
    _converter = t.Dict(
        {
            t.Key("datetime_column_format"):  t.String(),
            t.Key("datetime_column_name"):  t.String(),
            t.Key("effective_feature_derivation_window_end"):  t.Int(),
            t.Key("effective_feature_derivation_window_start"):  t.Int(),
            t.Key("feature_derivation_window_end"):  t.Int(),
            t.Key("feature_derivation_window_start"):  t.Int(),
            t.Key("forecast_distance_column_name"):  t.String(),
            t.Key("forecast_distances"):  t.List(t.Dict().allow_extra("*")),
            t.Key("forecast_distances_time_unit"):  t.String(),
            t.Key("forecast_point_column_name"):  t.String(),
            t.Key("is_cross_series"):  t.Bool(),
            t.Key("is_new_series_support"):  t.Bool(),
            t.Key("is_traditional_time_series"):  t.Bool(),
            t.Key("series_column_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datetime_column_format,
        datetime_column_name,
        effective_feature_derivation_window_end,
        effective_feature_derivation_window_start,
        feature_derivation_window_end,
        feature_derivation_window_start,
        forecast_distance_column_name,
        forecast_distances,
        forecast_distances_time_unit,
        forecast_point_column_name,
        is_cross_series,
        is_new_series_support,
        is_traditional_time_series,
        series_column_name,
    ):
        self.datetime_column_format = datetime_column_format
        self.datetime_column_name = datetime_column_name
        self.effective_feature_derivation_window_end = effective_feature_derivation_window_end
        self.effective_feature_derivation_window_start = effective_feature_derivation_window_start
        self.feature_derivation_window_end = feature_derivation_window_end
        self.feature_derivation_window_start = feature_derivation_window_start
        self.forecast_distance_column_name = forecast_distance_column_name
        self.forecast_distances = forecast_distances
        self.forecast_distances_time_unit = forecast_distances_time_unit
        self.forecast_point_column_name = forecast_point_column_name
        self.is_cross_series = is_cross_series
        self.is_new_series_support = is_new_series_support
        self.is_traditional_time_series = is_traditional_time_series
        self.series_column_name = series_column_name

    def __repr__(self):
        return (
            "ModelPackageTimeseries("
            "datetime_column_format={0.datetime_column_format}, "
            "datetime_column_name={0.datetime_column_name}, "
            "effective_feature_derivation_window_end={0.effective_feature_derivation_window_end}, "
            "effective_feature_derivation_window_start={0.effective_feature_derivation_window_start}, "
            "feature_derivation_window_end={0.feature_derivation_window_end}, "
            "feature_derivation_window_start={0.feature_derivation_window_start}, "
            "forecast_distance_column_name={0.forecast_distance_column_name}, "
            "forecast_distances={0.forecast_distances}, "
            "forecast_distances_time_unit={0.forecast_distances_time_unit}, "
            "forecast_point_column_name={0.forecast_point_column_name}, "
            "is_cross_series={0.is_cross_series}, "
            "is_new_series_support={0.is_new_series_support}, "
            "is_traditional_time_series={0.is_traditional_time_series}, "
            "series_column_name={0.series_column_name}, "
        ).format(self)
