#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.derived_features import DerivedFeatures
from datarobot.models.full_api.generated.model.parameters import Parameters

class ModelParametersRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    derived_features:[DerivedFeatures]
         An array of preprocessing information about derived features used in the model.
    parameters:[Parameters]
         An array of parameters that are related to the whole model.
    """
    _converter = t.Dict(
        {
            t.Key("derived_features"):  t.List(t.Dict().allow_extra("*")),
            t.Key("parameters"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        derived_features,
        parameters,
    ):
        self.derived_features = derived_features
        self.parameters = parameters

    def __repr__(self):
        return (
            "ModelParametersRetrieveResponse("
            "derived_features={0.derived_features}, "
            "parameters={0.parameters}, "
        ).format(self)
