#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelReplacementSubmission(APIObject):
    """
    Attributes
    ----------
    reason:str
         Reason for the model replacement.
    model_id:str [optional]
         ID of the model used to replace deployment's champion model. Required if modelPackageId is not provided.. 
    model_package_id:str [optional]
         ID of the model package used to replace deployment's champion model. Required if modelId is not provided.. 
    """
    _converter = t.Dict(
        {
            t.Key("reason"):  t.String(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("model_package_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        reason,
        model_id=None,
        model_package_id=None,
    ):
        self.reason = reason
        self.model_id = model_id
        self.model_package_id = model_package_id

    def __repr__(self):
        return (
            "ModelReplacementSubmission("
            "reason={0.reason}, "
            "model_id={0.model_id}, "
            "model_package_id={0.model_package_id}, "
        ).format(self)
