#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.model_residuals_histogram import ModelResidualsHistogram

class ModelResidualsChartData(APIObject):
    """
    Attributes
    ----------
    coefficient_of_determination:float
         Also known as the r-squared value. This value is calculated over the downsampled dataset, not the full input
    data:[[float]]
         The rows of chart data in [actual, predicted, residual, row number] form. If the row number was not available at the time of model creation, the row number will be null. **NOTE**: In DataRobot v5.2, the row number will not be included.
    histogram:[ModelResidualsHistogram]
         Data to plot a histogram of residual values
    residual_mean:float
         The arithmetic mean of the predicted value minus the actual value over the downsampled dataset
    standard_deviation:float
         A measure of deviation from the group as a whole
    """
    _converter = t.Dict(
        {
            t.Key("coefficient_of_determination"):  t.Float(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("histogram"):  t.List(t.Dict().allow_extra("*")),
            t.Key("residual_mean"):  t.Float(),
            t.Key("standard_deviation"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        coefficient_of_determination,
        data,
        histogram,
        residual_mean,
        standard_deviation,
    ):
        self.coefficient_of_determination = coefficient_of_determination
        self.data = data
        self.histogram = histogram
        self.residual_mean = residual_mean
        self.standard_deviation = standard_deviation

    def __repr__(self):
        return (
            "ModelResidualsChartData("
            "coefficient_of_determination={0.coefficient_of_determination}, "
            "data={0.data}, "
            "histogram={0.histogram}, "
            "residual_mean={0.residual_mean}, "
            "standard_deviation={0.standard_deviation}, "
        ).format(self)
