#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ModelResponse(APIObject):
    """
    Attributes
    ----------
    dataset_name:str
         Name of dataset used to train challenger model
    description:str
         Description of the model.
    execution_type:str
         Type of the current model.
    id:str
         ID of the current model.
    name:str
         Name of the model.
    project_id:str
         Project ID of the current model.
    project_name:str
         Project name of the current model.
    """
    _converter = t.Dict(
        {
            t.Key("dataset_name"):  t.String(),
            t.Key("description"):  t.String(),
            t.Key("execution_type"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("project_name"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_name,
        description,
        execution_type,
        id,
        name,
        project_id,
        project_name,
    ):
        self.dataset_name = dataset_name
        self.description = description
        self.execution_type = execution_type
        self.id = id
        self.name = name
        self.project_id = project_id
        self.project_name = project_name

    def __repr__(self):
        return (
            "ModelResponse("
            "dataset_name={0.dataset_name}, "
            "description={0.description}, "
            "execution_type={0.execution_type}, "
            "id={0.id}, "
            "name={0.name}, "
            "project_id={0.project_id}, "
            "project_name={0.project_name}, "
        ).format(self)
