#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.roc_points_response import RocPointsResponse

class ModelRocCurveResponse(APIObject):
    """
    Attributes
    ----------
    auc:float, none_type
         AUC value
    kolmogorov_smirnov_metric:float, none_type
         Kolmogorov-Smirnov metric value
    negative_class_predictions:[float]
         List of example predictions for the negative class.
    positive_class_predictions:[float]
         List of example predictions for the positive class.
    roc_points:[RocPointsResponse]
         The ROC curve data for that source, as specified below.
    source:str
         Source of the data.
    """
    _converter = t.Dict(
        {
            t.Key("auc"):  t.Float(),
            t.Key("kolmogorov_smirnov_metric"):  t.Float(),
            t.Key("negative_class_predictions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("positive_class_predictions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("roc_points"):  t.List(t.Dict().allow_extra("*")),
            t.Key("source"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        auc,
        kolmogorov_smirnov_metric,
        negative_class_predictions,
        positive_class_predictions,
        roc_points,
        source,
    ):
        self.auc = auc
        self.kolmogorov_smirnov_metric = kolmogorov_smirnov_metric
        self.negative_class_predictions = negative_class_predictions
        self.positive_class_predictions = positive_class_predictions
        self.roc_points = roc_points
        self.source = source

    def __repr__(self):
        return (
            "ModelRocCurveResponse("
            "auc={0.auc}, "
            "kolmogorov_smirnov_metric={0.kolmogorov_smirnov_metric}, "
            "negative_class_predictions={0.negative_class_predictions}, "
            "positive_class_predictions={0.positive_class_predictions}, "
            "roc_points={0.roc_points}, "
            "source={0.source}, "
        ).format(self)
