#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.multilabel_insights_response import MultilabelInsightsResponse

class ModelingFeatureResponse(APIObject):
    """
    Attributes
    ----------
    date_format:str, none_type
         the date format string for how this feature was interpreted (or null if not a date feature).  If not null, it will be compatible with https://docs.python.org/2/library/time.html#time.strftime .
    feature_lineage_id:str, none_type
         id of a lineage for automatically generated features.
    feature_type:str
         Feature type.
    importance:float, none_type
         numeric measure of the strength of relationship between the feature and target (independent of any model or other features)
    low_information:bool
         whether feature has too few values to be informative
    max:bool, date, datetime, dict, float, int, list, str, none_type
         maximum value of the EDA sample of the feature.
    mean:bool, date, datetime, dict, float, int, list, str, none_type
         arithmetic mean of the EDA sample of the feature.
    median:bool, date, datetime, dict, float, int, list, str, none_type
         median of the EDA sample of the feature.
    min:bool, date, datetime, dict, float, int, list, str, none_type
         minimum value of the EDA sample of the feature.
    na_count:int
         number of missing values
    name:str
         feature name
    project_id:str
         the ID of the project the feature belongs to
    std_dev:bool, date, datetime, dict, float, int, list, str, none_type
         standard deviation of EDA sample of the feature.
    target_leakage:str
         the detected level of risk for target leakage, if any. 'SKIPPED_DETECTION' indicates leakage detection was not run on the feature, 'FALSE' indicates no leakage, 'MODERATE_RISK' indicates a moderate risk of target leakage, and 'HIGH_RISK' indicates a high risk of target leakage.
    target_leakage_reason:str
         descriptive sentence explaining the reason for target leakage.
    data_qualities:str [optional]
         Data Quality Status. 
    is_restored_after_reduction:bool [optional]
         Whether feature is restored after feature reduction. 
    is_zero_inflated:bool, none_type [optional]
         Whether feature has an excessive number of zeros. 
    key_summary:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         Per key summaries for Summarized Categorical or Multicategorical columns. 
    multilabel_insights:MultilabelInsightsResponse [optional]
         
    parent_feature_names:[str] [optional]
         an array of string feature names indicating which features in the input data were used to create this feature if the feature is a transformation.. 
    unique_count:int [optional]
         number of unique values. 
    """
    _converter = t.Dict(
        {
            t.Key("date_format"):  t.String(),
            t.Key("feature_lineage_id"):  t.String(),
            t.Key("feature_type"):  t.String(),
            t.Key("importance"):  t.Float(),
            t.Key("low_information"):  t.Bool(),
            t.Key("max"):  t.Any(),
            t.Key("mean"):  t.Any(),
            t.Key("median"):  t.Any(),
            t.Key("min"):  t.Any(),
            t.Key("na_count"):  t.Int(),
            t.Key("name"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("std_dev"):  t.Any(),
            t.Key("target_leakage"):  t.String(),
            t.Key("target_leakage_reason"):  t.String(),
            t.Key("data_qualities", optional=True):  t.String(),
            t.Key("is_restored_after_reduction", optional=True):  t.Bool(),
            t.Key("is_zero_inflated", optional=True):  t.Bool(),
            t.Key("key_summary", optional=True):  t.Any(),
            t.Key("multilabel_insights", optional=True):  t.Any(),
            t.Key("parent_feature_names", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("unique_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        date_format,
        feature_lineage_id,
        feature_type,
        importance,
        low_information,
        max,
        mean,
        median,
        min,
        na_count,
        name,
        project_id,
        std_dev,
        target_leakage,
        target_leakage_reason,
        data_qualities=None,
        is_restored_after_reduction=None,
        is_zero_inflated=None,
        key_summary=None,
        multilabel_insights=None,
        parent_feature_names=None,
        unique_count=None,
    ):
        self.date_format = date_format
        self.feature_lineage_id = feature_lineage_id
        self.feature_type = feature_type
        self.importance = importance
        self.low_information = low_information
        self.max = max
        self.mean = mean
        self.median = median
        self.min = min
        self.na_count = na_count
        self.name = name
        self.project_id = project_id
        self.std_dev = std_dev
        self.target_leakage = target_leakage
        self.target_leakage_reason = target_leakage_reason
        self.data_qualities = data_qualities
        self.is_restored_after_reduction = is_restored_after_reduction
        self.is_zero_inflated = is_zero_inflated
        self.key_summary = key_summary
        self.multilabel_insights = multilabel_insights
        self.parent_feature_names = parent_feature_names
        self.unique_count = unique_count

    def __repr__(self):
        return (
            "ModelingFeatureResponse("
            "date_format={0.date_format}, "
            "feature_lineage_id={0.feature_lineage_id}, "
            "feature_type={0.feature_type}, "
            "importance={0.importance}, "
            "low_information={0.low_information}, "
            "max={0.max}, "
            "mean={0.mean}, "
            "median={0.median}, "
            "min={0.min}, "
            "na_count={0.na_count}, "
            "name={0.name}, "
            "project_id={0.project_id}, "
            "std_dev={0.std_dev}, "
            "target_leakage={0.target_leakage}, "
            "target_leakage_reason={0.target_leakage_reason}, "
            "data_qualities={0.data_qualities}, "
            "is_restored_after_reduction={0.is_restored_after_reduction}, "
            "is_zero_inflated={0.is_zero_inflated}, "
            "key_summary={0.key_summary}, "
            "multilabel_insights={0.multilabel_insights}, "
            "parent_feature_names={0.parent_feature_names}, "
            "unique_count={0.unique_count}, "
        ).format(self)
