#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class MonetaryValue(APIObject):
    """
    Attributes
    ----------
    currency:str
         ISO code of currency
    value:float
         Amount of value
    details:str, none_type [optional]
         Optional user notes. 
    """
    _converter = t.Dict(
        {
            t.Key("currency"):  t.String(),
            t.Key("value"):  t.Float(),
            t.Key("details", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        currency,
        value,
        details=None,
    ):
        self.currency = currency
        self.value = value
        self.details = details

    def __repr__(self):
        return (
            "MonetaryValue("
            "currency={0.currency}, "
            "value={0.value}, "
            "details={0.details}, "
        ).format(self)
