#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.feature_impact_item import FeatureImpactItem

class MulticlassFeatureImpact(APIObject):
    """
    Attributes
    ----------
    _class:str
         Target class label.
    feature_impacts:[FeatureImpactItem]
         A list which contains feature impact scores for each feature used by a model. If the model has more than 1000 features, the most important 1000 features are returned.
    """
    _converter = t.Dict(
        {
            t.Key("_class"):  t.String(),
            t.Key("feature_impacts"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        _class,
        feature_impacts,
    ):
        self._class = _class
        self.feature_impacts = feature_impacts

    def __repr__(self):
        return (
            "MulticlassFeatureImpact("
            "_class={0._class}, "
            "feature_impacts={0.feature_impacts}, "
        ).format(self)
