#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.multiclass_feature_impact import MulticlassFeatureImpact

class MulticlassFeatureImpactResponse(APIObject):
    """
    Attributes
    ----------
    class_feature_impacts:[MulticlassFeatureImpact]
         A list of feature importance scores for each class in multiclass project.
    ran_redundancy_detection:bool
         Indicates whether redundant feature identification was run while calculating this feature impact. Currently always False, as redundant feature identification isn't supported for multiclass in DataRobot.
    shap_based:bool
         Indicates whether feature impact was calculated using Shapley values. Currently always `False`, as SHAP isn't supported for multiclass in DataRobot.
    """
    _converter = t.Dict(
        {
            t.Key("class_feature_impacts"):  t.List(t.Dict().allow_extra("*")),
            t.Key("ran_redundancy_detection"):  t.Bool(),
            t.Key("shap_based"):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_feature_impacts,
        ran_redundancy_detection,
        shap_based,
    ):
        self.class_feature_impacts = class_feature_impacts
        self.ran_redundancy_detection = ran_redundancy_detection
        self.shap_based = shap_based

    def __repr__(self):
        return (
            "MulticlassFeatureImpactResponse("
            "class_feature_impacts={0.class_feature_impacts}, "
            "ran_redundancy_detection={0.ran_redundancy_detection}, "
            "shap_based={0.shap_based}, "
        ).format(self)
