#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.multiclass_lift_data import MulticlassLiftData

class MulticlassLiftChartForDatasetsList(APIObject):
    """
    Attributes
    ----------
    count:int
         Number of results returned on this page.
    data:[MulticlassLiftData]
         Array of multiclass lift chart data for dataset, as specified below.
    model_id:str
         The model id to which the chart data belongs.
    next:str, none_type
         URL pointing to the next page (if null, there is no next page).
    previous:str, none_type
         URL pointing to the previous page (if null, there is no previous page).
    project_id:str
         The project id to which the chart data belongs.
    total_count:int
         Total count of multiclass lift charts matching to the query condition.
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("model_id"):  t.String(),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("total_count"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        data,
        model_id,
        next,
        previous,
        project_id,
        total_count,
    ):
        self.count = count
        self.data = data
        self.model_id = model_id
        self.next = next
        self.previous = previous
        self.project_id = project_id
        self.total_count = total_count

    def __repr__(self):
        return (
            "MulticlassLiftChartForDatasetsList("
            "count={0.count}, "
            "data={0.data}, "
            "model_id={0.model_id}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "project_id={0.project_id}, "
            "total_count={0.total_count}, "
        ).format(self)
