#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.multiclass_lift_data_class_bins import MulticlassLiftDataClassBins

class MulticlassLiftData(APIObject):
    """
    Attributes
    ----------
    class_bins:[MulticlassLiftDataClassBins]
         List of lift chart data for each target class.
    dataset_id:str
         The dataset id of dataset which was used to compute Lift chart.
    """
    _converter = t.Dict(
        {
            t.Key("class_bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("dataset_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        class_bins,
        dataset_id,
    ):
        self.class_bins = class_bins
        self.dataset_id = dataset_id

    def __repr__(self):
        return (
            "MulticlassLiftData("
            "class_bins={0.class_bins}, "
            "dataset_id={0.dataset_id}, "
        ).format(self)
