#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class MultiseriesHistogramsBin(APIObject):
    """
    Attributes
    ----------
    count:int
         The value count of the bin
    left:bool, date, datetime, dict, float, int, list, str, none_type
         The inclusive left boundary of the bin.
    right:bool, date, datetime, dict, float, int, list, str, none_type
         The exclusive right boundary of the bin. The last bin has an inclusive right boundary.
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("left"):  t.Any(),
            t.Key("right"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        left,
        right,
    ):
        self.count = count
        self.left = left
        self.right = right

    def __repr__(self):
        return (
            "MultiseriesHistogramsBin("
            "count={0.count}, "
            "left={0.left}, "
            "right={0.right}, "
        ).format(self)
