#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class MultiseriesIdColumnsRecord(APIObject):
    """
    Attributes
    ----------
    multiseries_id_columns:[str]
         A list of one or more names of columns that contain the individual series identifiers if the dataset consists of multiple time series.
    time_step:int
         timeStep: detected time step
    time_unit:str
         detected time unit (e.g. DAY, HOUR, etc.)
    """
    _converter = t.Dict(
        {
            t.Key("multiseries_id_columns"):  t.List(t.Dict().allow_extra("*")),
            t.Key("time_step"):  t.Int(),
            t.Key("time_unit"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        multiseries_id_columns,
        time_step,
        time_unit,
    ):
        self.multiseries_id_columns = multiseries_id_columns
        self.time_step = time_step
        self.time_unit = time_unit

    def __repr__(self):
        return (
            "MultiseriesIdColumnsRecord("
            "multiseries_id_columns={0.multiseries_id_columns}, "
            "time_step={0.time_step}, "
            "time_unit={0.time_unit}, "
        ).format(self)
