#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class MultiseriesPayload(APIObject):
    """
    Attributes
    ----------
    datetime_partition_column:str
         The date column that will be used to perform detection and validation for.
    multiseries_id_columns:[str] [optional]
         List of one or more names of potential multiseries id columns.  If not provided, all numerical and categorical columns are used.. 
    """
    _converter = t.Dict(
        {
            t.Key("datetime_partition_column"):  t.String(),
            t.Key("multiseries_id_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datetime_partition_column,
        multiseries_id_columns=None,
    ):
        self.datetime_partition_column = datetime_partition_column
        self.multiseries_id_columns = multiseries_id_columns

    def __repr__(self):
        return (
            "MultiseriesPayload("
            "datetime_partition_column={0.datetime_partition_column}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
        ).format(self)
